'20X2 i2c slave to Arduino i2c master bridge interface
'for autonomously reading serially 2 x 2 bytes of temperature information from 
'a remote picaxe 14M2 and 2 x DS18B20's via Xbee link
'20X2 configured for both backgrouns mode and i2c slave operation

#picaxe 20x2
#no_data


dirsC=%10111111	'C.0 hserout, C.6 can only be an input			'
dirsB=%00000000	'B.6 hserin
pullup ON		'b.7 b.6 b.5 b.1 b.0 c.7 c.6 c.0 (20X2)

setfreq m16				'need m16 to make i2c slave work at i2c 400khz

hsersetup B2400_16, %0001	'T2400, background mode

hi2csetup i2cslave, 0xA8	'initialise 20x2 i2c slave operation

w8 = 0
w9 = 0	'program counters

for b23 = 0 to 15			'initialise xbee link, send a few hserout's, populate scratchpad
	gosub poll_sensors
	pause 2000
next b23

b0=0

'----------------------------------------------
main:

if w8 = 10600 then :w9=w9+1 :w8=0 :endif				'select on test to give 15 secs
if w9 = 2 then :w9 = 0 :gosub poll_sensors :w9 = 0 :endif	'2 = 2*15 secs = 30 secs >> poll	

w8 = w8+1									'inc program counter

goto main

'----------------------------------------------
poll_sensors:

hserptr=0			'reset the scratchpad pointer
hserinflag=0		'reset the hserinflag

hserout 0,("RP")		'poll remote temperature sensor with a 2 byte query (R and P) 
				'the response is deposited directly to scratchpad, no need for hserin
				'6 byte response (R,Q,tempA hi byte, tempA lo byte, tempB hi byte, tempB lo byte)
return

